<?php
// Include database connection
include 'conn.php';

// Initialize variables
$message = "";
$errors = [];

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve and sanitize form data
    $admission_number = $_POST['admission_number'];
    $fullname = $_POST['fullname'];
    $class = $_POST['class'];

    // Handle file upload
    $target_dir = "studentpassport/";
    $target_file = $target_dir . basename($_FILES["picture"]["name"]);
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    // Check if file is an image
    $check = getimagesize($_FILES["picture"]["tmp_name"]);
    if ($check === false) {
        $errors['picture'] = "File is not an image.";
        $uploadOk = 0;
    }

    // Check file size (e.g., limit to 2MB)
    if ($_FILES["picture"]["size"] > 2000000) {
        $errors['picture'] = "Sorry, your file is too large.";
        $uploadOk = 0;
    }

    // Allow certain file formats
    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
        $errors['picture'] = "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
        $uploadOk = 0;
    }

    // Check if $uploadOk is set to 0 by an error
    if ($uploadOk == 0) {
        $message = "Sorry, your file was not uploaded.";
    } else {
        // Check for duplicate admission number
        $sql = "SELECT * FROM students WHERE admission_number='$admission_number'";
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            $errors['admission_number'] = "Admission number already exists.";
        } else {
            // If everything is ok, try to upload file
            if (move_uploaded_file($_FILES["picture"]["tmp_name"], $target_file)) {
                // Insert data into the database
                $sql = "INSERT INTO students (admission_number, fullname, class, picture) VALUES ('$admission_number', '$fullname', '$class', '$target_file')";

                if ($conn->query($sql) === TRUE) {
                    $message = "New record created successfully";
                } else {
                    $message = "Error: " . $sql . "<br>" . $conn->error;
                }
            } else {
                $errors['picture'] = "Sorry, there was an error uploading your file.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Student</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background: linear-gradient(135deg, #f0f4f8, #d9e2ec);
            color: #333;
        }
        .navbar {
            display: flex;
            justify-content: center;
            align-items: center;
            background: #ffffff;
            padding: 15px 30px;
            color: #333;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            border-bottom: 1px solid #ddd;
        }
        .navbar .nav-links {
            display: flex;
            gap: 20px;
        }
        .navbar .nav-links a {
            color: #007bff;
            text-decoration: none;
            font-size: 16px;
            font-weight: 500;
            padding: 10px 15px;
            border-radius: 5px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }
        .navbar .nav-links a i {
            margin-right: 8px;
        }
        .navbar .nav-links a:hover {
            background-color: #e2e6ea;
            color: #0056b3;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            box-sizing: border-box;
            animation: fadeIn 1s ease-out;
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
        }
        .form-group input[type="text"],
        .form-group input[type="file"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }
        .form-group input:focus {
            border-color: #007bff;
            outline: none;
        }
        .form-group .error-message {
            color: #dc3545;
            font-size: 14px;
            margin-top: 5px;
            display: block;
        }
        .form-group i {
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
            color: #888;
        }
        .form-group input {
            padding-left: 40px;
        }
        .btn-submit {
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: #ffffff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }
        .btn-submit:hover {
            background-color: #0056b3;
            transform: scale(1.05);
        }
        .message {
            text-align: center;
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            font-size: 16px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .message.success {
            color: #28a745;
            border: 1px solid #28a745;
            background-color: #d4edda;
        }
        .message.error {
            color: #dc3545;
            border: 1px solid #dc3545;
            background-color: #f8d7da;
        }
        @keyframes fadeIn {
            from {
                opacity: 0;
            }
            to {
                opacity: 1;
            }
        }
    </style>
</head>
<body>
    <div class="navbar">
        <div class="nav-links">
            <a href="give_book.php"><i class="fas fa-home"></i> Give Book</a>
            <a href="returnbook.php"><i class="fas fa-book-return"></i> Return Book</a>
            <a href="Insert_book.php"><i class="fas fa-book"></i> Add New Book</a>
            <a href="search_report.php"><i class="fas fa-file-alt"></i> Generate Report</a>
        </div>
    </div>

    <div class="container">
        <h2><i class="fas fa-user-plus"></i> Add Student</h2>
        <form method="post" action="" enctype="multipart/form-data">
            <div class="form-group">
                <label for="admission_number">Admission Number</label>
                <input type="text" id="admission_number" name="admission_number" required>
                <?php if (!empty($errors['admission_number'])): ?>
                    <span class="error-message"><?php echo $errors['admission_number']; ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label for="fullname">Full Name</label>
                <input type="text" id="fullname" name="fullname" required>
                <?php if (!empty($errors['fullname'])): ?>
                    <span class="error-message"><?php echo $errors['fullname']; ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label for="class">Class</label>
                <input type="text" id="class" name="class" required>
                <?php if (!empty($errors['class'])): ?>
                    <span class="error-message"><?php echo $errors['class']; ?></span>
                <?php endif; ?>
            </div>
            <div class="form-group">
                <label for="picture">Picture</label>
                <input type="file" id="picture" name="picture" accept="image/*" required>
                <?php if (!empty($errors['picture'])): ?>
                    <span class="error-message"><?php echo $errors['picture']; ?></span>
                <?php endif; ?>
            </div>
            <button type="submit" class="btn-submit"><i class="fas fa-plus"></i> Add Student</button>
        </form>
        <?php if (!empty($message)): ?>
            <div class="message <?php echo strpos($message, 'error') !== false ? 'error' : 'success'; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
